/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration;

import com.james.tinkerscalibration.BlueSkiesIntegration;
import com.james.tinkerscalibration.ConstructsArmoryIntegration;
import com.james.tinkerscalibration.DarkMatterTier;
import com.james.tinkerscalibration.ModGroup;
import com.james.tinkerscalibration.RedMatterTier;
import com.james.tinkerscalibration.TinkersCalibrationBlockStates;
import com.james.tinkerscalibration.TinkersCalibrationBlockTags;
import com.james.tinkerscalibration.TinkersCalibrationBlocks;
import com.james.tinkerscalibration.TinkersCalibrationConfig;
import com.james.tinkerscalibration.TinkersCalibrationEntities;
import com.james.tinkerscalibration.TinkersCalibrationFluidTags;
import com.james.tinkerscalibration.TinkersCalibrationFluids;
import com.james.tinkerscalibration.TinkersCalibrationGadgets;
import com.james.tinkerscalibration.TinkersCalibrationItemTags;
import com.james.tinkerscalibration.TinkersCalibrationItems;
import com.james.tinkerscalibration.TinkersCalibrationItemsModels;
import com.james.tinkerscalibration.TinkersCalibrationOreGen;
import com.james.tinkerscalibration.TinkersCalibrationTags;
import com.james.tinkerscalibration.TinkersCalibrationToolDefinitionDataProvider;
import com.james.tinkerscalibration.TinkersCalibrationToolStationLayout;
import com.james.tinkerscalibration.Utils;
import com.james.tinkerscalibration.item.FiberGlass;
import com.james.tinkerscalibration.item.HymonArrow;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tinkerscalibration")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TinkersCalibration {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "tinkerscalibration";
    public static final DeferredRegister<Item> Items = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tinkerscalibration");
    public static RegistryObject<Item> Fiberglass = Items.register("fiberglass", TinkersCalibration::register);
    public static RegistryObject<Item> Hymon_Arrow = Items.register("hymon_arrow", TinkersCalibration::register);

    public TinkersCalibration() {
        TinkersCalibrationTags.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)TinkersCalibrationConfig.config);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        bus.addListener(this::setup);
        TinkersCalibrationFluids.FLUIDS.register(bus);
        TinkersCalibrationBlocks.BLOCKS.register(bus);
        TinkersCalibrationItems.ITEMS.register(bus);
        TinkersCalibrationEntities.ENTITIES.register(bus);
        TinkersCalibrationGadgets.ITEMS.register(bus);
        Utils.MODIFIERS.register(bus);
        TinkersCalibrationOreGen.CONFIGURED_FEATURES.register(bus);
        TinkersCalibrationOreGen.PLACED_FEATURES.register(bus);
        FiberGlass.ItemRegistry.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        HymonArrow.ItemRegistry.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        Utils.RECIPE_SERIALIZERS.register(bus);
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        if (event.includeClient()) {
            gen.m_123914_((DataProvider)new TinkersCalibrationBlockStates(gen, fileHelper));
            gen.m_123914_((DataProvider)new TinkersCalibrationItemsModels(gen, fileHelper));
        }
        if (event.includeServer()) {
            TinkersCalibrationBlockTags tags = new TinkersCalibrationBlockTags(gen, fileHelper);
            gen.m_123914_((DataProvider)tags);
            gen.m_123914_((DataProvider)new TinkersCalibrationToolDefinitionDataProvider(gen));
            gen.m_123914_((DataProvider)new TinkersCalibrationToolStationLayout(gen));
            gen.m_123914_((DataProvider)new TinkersCalibrationFluidTags(gen, fileHelper));
            gen.m_123914_((DataProvider)new TinkersCalibrationItemTags(gen, tags, fileHelper));
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        boolean ca;
        boolean pe = ModList.get().isLoaded("projecte");
        if (pe) {
            if (!TierSortingRegistry.isTierSorted((Tier)RedMatterTier.instance)) {
                if (TierSortingRegistry.getSortedTiers().size() != 0) {
                    TierSortingRegistry.registerTier((Tier)RedMatterTier.instance, (ResourceLocation)new ResourceLocation("tinkerscalibration:redmatter"), List.of(TierSortingRegistry.getSortedTiers().get(TierSortingRegistry.getSortedTiers().size())), List.of());
                } else {
                    TierSortingRegistry.registerTier((Tier)RedMatterTier.instance, (ResourceLocation)new ResourceLocation("tinkerscalibration:redmatter"), List.of(Tiers.NETHERITE), List.of());
                }
            } else if (!TierSortingRegistry.isTierSorted((Tier)RedMatterTier.instance)) {
                if (TierSortingRegistry.getSortedTiers().size() != 0) {
                    TierSortingRegistry.registerTier((Tier)Tiers.NETHERITE, (ResourceLocation)new ResourceLocation("tinkerscalibration:redmatter"), List.of(TierSortingRegistry.getSortedTiers().get(TierSortingRegistry.getSortedTiers().size())), List.of());
                } else {
                    TierSortingRegistry.registerTier((Tier)Tiers.NETHERITE, (ResourceLocation)new ResourceLocation("tinkerscalibration:redmatter"), List.of(Tiers.NETHERITE), List.of());
                }
            }
        }
        if (!TierSortingRegistry.isTierSorted((Tier)DarkMatterTier.instance)) {
            if (TierSortingRegistry.getSortedTiers().size() != 0) {
                TierSortingRegistry.registerTier((Tier)DarkMatterTier.instance, (ResourceLocation)new ResourceLocation("tinkerscalibration:darkmatter"), List.of(TierSortingRegistry.getSortedTiers().get(TierSortingRegistry.getSortedTiers().size())), List.of());
            } else {
                TierSortingRegistry.registerTier((Tier)DarkMatterTier.instance, (ResourceLocation)new ResourceLocation("tinkerscalibration:darkmatter"), List.of(Tiers.NETHERITE), List.of());
            }
        } else if (!TierSortingRegistry.isTierSorted((Tier)DarkMatterTier.instance)) {
            if (TierSortingRegistry.getSortedTiers().size() != 0) {
                TierSortingRegistry.registerTier((Tier)Tiers.NETHERITE, (ResourceLocation)new ResourceLocation("tinkerscalibration:darkmatter"), List.of(TierSortingRegistry.getSortedTiers().get(TierSortingRegistry.getSortedTiers().size())), List.of());
            } else {
                TierSortingRegistry.registerTier((Tier)Tiers.NETHERITE, (ResourceLocation)new ResourceLocation("tinkerscalibration:darkmatter"), List.of(Tiers.NETHERITE), List.of());
            }
        }
        boolean bs = ModList.get().isLoaded("blue_skies");
        if (bs) {
            BlueSkiesIntegration.Init();
        }
        if (ca = ModList.get().isLoaded("constructsarmory")) {
            ConstructsArmoryIntegration.Init();
            boolean tw = ModList.get().isLoaded("twilightforest");
            if (tw) {
                ConstructsArmoryIntegration.InitT();
            }
        }
    }

    public static Item.Properties defaultItemProperties() {
        return new Item.Properties().m_41491_(ModGroup.itemGroup);
    }

    public static Item register() {
        return new Item(new Item.Properties().m_41491_(ModGroup.itemGroup));
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

